/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.common.world.gen.feature;

import com.mojang.serialization.Codec;
import gloridifice.watersource.common.block.CoconutSaplingBlock;
import gloridifice.watersource.common.block.NaturalCoconutBlock;
import gloridifice.watersource.common.world.gen.config.CoconutTreeFeatureConfig;
import gloridifice.watersource.registry.BlockRegistry;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.IPlantable;

public class CoconutTreeFeature
extends Feature<CoconutTreeFeatureConfig> {
    public CoconutTreeFeature(Codec<CoconutTreeFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader iSeedReader, ChunkGenerator chunkGenerator, Random rand, BlockPos positionIn, CoconutTreeFeatureConfig configIn) {
        int a = rand.nextInt(4);
        int height = 7 + rand.nextInt(2);
        if (CoconutTreeFeature.isSand((IWorldGenerationBaseReader)iSeedReader, positionIn.func_177977_b()) && this.canPlace((IWorldGenerationBaseReader)iSeedReader, positionIn, height, a)) {
            int i;
            BlockPos pos = positionIn;
            for (i = 0; i < height / 2; ++i) {
                pos = positionIn.func_177981_b(i);
                this.func_230367_a_((IWorldWriter)iSeedReader, pos, configIn.trunkProvider.func_225574_a_(rand, pos));
            }
            for (i = 0; i < height / 2; ++i) {
                pos = positionIn.func_177981_b(height / 2 + i).func_177972_a(Direction.func_82600_a((int)(a + 2)));
                if (i == height / 2 - 1) {
                    this.func_230367_a_((IWorldWriter)iSeedReader, pos, BlockRegistry.BLOCK_COCONUT_TREE_HEAD.func_176223_P());
                    for (int n = 2; n <= 5; ++n) {
                        if (rand.nextInt(4) != 0) continue;
                        this.placeLeaves((IWorldGenerationReader)iSeedReader, pos.func_177972_a(Direction.func_82600_a((int)n)), (BlockState)((BlockState)BlockRegistry.BLOCK_NATURAL_COCONUT.func_176223_P().func_206870_a((Property)NaturalCoconutBlock.AGE, (Comparable)Integer.valueOf(3))).func_206870_a((Property)NaturalCoconutBlock.field_185512_D, (Comparable)Direction.func_82600_a((int)n).func_176734_d()));
                    }
                    continue;
                }
                this.func_230367_a_((IWorldWriter)iSeedReader, pos, configIn.trunkProvider.func_225574_a_(rand, pos));
            }
            pos = pos.func_177984_a();
            this.placeLeaves((IWorldGenerationReader)iSeedReader, pos, (BlockState)configIn.leavesProvider.func_225574_a_(rand, pos).func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)));
            for (i = 1; i <= 5; ++i) {
                for (int j = 2; j <= 5; ++j) {
                    if (i <= 4) {
                        this.placeLeaves((IWorldGenerationReader)iSeedReader, pos.func_177967_a(Direction.func_82600_a((int)j), i), (BlockState)configIn.leavesProvider.func_225574_a_(rand, pos.func_177985_f(i)).func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)));
                    }
                    if (i == 2) {
                        this.placeLeaves((IWorldGenerationReader)iSeedReader, pos.func_177967_a(Direction.func_82600_a((int)j), i).func_177984_a(), (BlockState)configIn.leavesProvider.func_225574_a_(rand, pos.func_177985_f(i).func_177984_a()).func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)));
                        for (int u = 2; u <= 5; ++u) {
                            this.placeLeaves((IWorldGenerationReader)iSeedReader, pos.func_177967_a(Direction.func_82600_a((int)j), i).func_177972_a(Direction.func_82600_a((int)u)), (BlockState)configIn.leavesProvider.func_225574_a_(rand, pos.func_177985_f(i).func_177984_a()).func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)));
                        }
                    }
                    if (i != 4 && i != 2 && i != 5) continue;
                    this.placeLeaves((IWorldGenerationReader)iSeedReader, pos.func_177967_a(Direction.func_82600_a((int)j), i).func_177977_b(), (BlockState)configIn.leavesProvider.func_225574_a_(rand, pos.func_177985_f(i).func_177977_b()).func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1)));
                }
            }
            return true;
        }
        return false;
    }

    protected static boolean isSand(IWorldGenerationBaseReader reader, BlockPos pos) {
        if (!(reader instanceof IBlockReader)) {
            return reader.func_217375_a(pos, data -> BlockTags.func_199896_a().func_199910_a(new ResourceLocation("watersource", "coconut_soil")).func_230235_a_((Object)data.func_177230_c()));
        }
        return reader.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)reader, pos, Direction.UP, (IPlantable)((CoconutSaplingBlock)BlockRegistry.BLOCK_COCONUT_SAPLING)));
    }

    protected boolean placeLeaves(IWorldGenerationReader generationReader, BlockPos pos, BlockState blockState) {
        if (CoconutTreeFeature.isAirOrLeavesAt((IWorldGenerationBaseReader)generationReader, pos)) {
            this.func_230367_a_((IWorldWriter)generationReader, pos, blockState);
            return true;
        }
        return false;
    }

    protected boolean canPlace(IWorldGenerationBaseReader generationReader, BlockPos positionIn, int height, int randA) {
        BlockPos pos;
        int i;
        boolean flag = true;
        for (i = 0; i < height / 2; ++i) {
            pos = positionIn.func_177981_b(i);
            boolean bl = flag = flag && CoconutTreeFeature.isReplaceableAt(generationReader, pos);
            if (flag) continue;
            return flag;
        }
        for (i = 0; i < height / 2; ++i) {
            pos = positionIn.func_177981_b(height / 2 + i).func_177972_a(Direction.func_82600_a((int)(randA + 2)));
            if (i != height / 2 - 1) continue;
            boolean bl = flag = flag && CoconutTreeFeature.isReplaceableAt(generationReader, pos);
            if (flag) continue;
            return flag;
        }
        return flag;
    }

    private static boolean isWaterAt(IWorldGenerationBaseReader p_236416_0_, BlockPos p_236416_1_) {
        return p_236416_0_.func_217375_a(p_236416_1_, p_236413_0_ -> p_236413_0_.func_203425_a(Blocks.field_150355_j));
    }

    private static boolean isTallPlantAt(IWorldGenerationBaseReader p_236419_0_, BlockPos p_236419_1_) {
        return p_236419_0_.func_217375_a(p_236419_1_, p_236406_0_ -> {
            Material lvt_1_1_ = p_236406_0_.func_185904_a();
            return lvt_1_1_ == Material.field_151582_l;
        });
    }

    public static boolean isReplaceableAt(IWorldGenerationBaseReader p_236404_0_, BlockPos p_236404_1_) {
        return CoconutTreeFeature.isAirOrLeavesAt(p_236404_0_, p_236404_1_) || CoconutTreeFeature.isTallPlantAt(p_236404_0_, p_236404_1_) || CoconutTreeFeature.isWaterAt(p_236404_0_, p_236404_1_);
    }

    public static boolean isAirOrLeavesAt(IWorldGenerationBaseReader p_236412_0_, BlockPos p_236412_1_) {
        return p_236412_0_.func_217375_a(p_236412_1_, p_236411_0_ -> p_236411_0_.func_196958_f() || p_236411_0_.func_235714_a_((ITag)BlockTags.field_206952_E));
    }
}

